IF  EXISTS (SELECT * FROM SYS.VIEWS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[V_INFORMACAO_DIVERSAS_MANUTENCAO_SAIDA]'))

DROP VIEW [dbo].[V_INFORMACAO_DIVERSAS_MANUTENCAO_SAIDA]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW 
	[dbo].[V_INFORMACAO_DIVERSAS_MANUTENCAO_SAIDA]
AS             
---- Buscando o numero do pedido do fornecedor
SELECT 
	CD_EMP,
	CD_FILIAL,
	CD_NF,
	'Protocolo NFe.:' + CAST(NR_PROTOCOLO AS VARCHAR) +' Autorizao.:' + 
	CAST(NR_AUTORIZADOR AS VARCHAR) + ' Data Recebimento: '  + CONVERT (VARCHAR (10), DT_RECBTO,103) AS INFORMACAO
FROM EST_NF_SAI_NFE

UNION ALL

----- INFORMAES DE DUPLICATA
SELECT 
	RC_DEB_DUP_NR_CTR.CD_EMP,
	RC_DEB_DUP_NR_CTR.CD_FILIAL,
	RC_DEB_EST_NF_SAI.CD_NF,

	'Filial: ' + cast(RC_DEB_DUP_NR_CTR.CD_FILIAL as varchar) + 
	+ ' Duplicata: ' + cast(RC_DEB_DUP_NR_CTR.NR_DP as varchar) + ' Parcela: ' + cast(RC_DEB.PARC AS varchar)
	+ ' Valor R$ ' + cast(RC_DEB.VLR_DP as varchar)
	+ ' Data Cadastro: ' + CONVERT (VARCHAR (10), RC_DEB.DT_CAD,103)
	+ ' Data Vecimento: ' + CONVERT (VARCHAR (10), RC_DEB.DT_VENCTO,103)
	as INFORMACAO

FROM RC_DEB INNER JOIN RC_DEB_DUP_NR_CTR ON  
	RC_DEB.CD_EMP = RC_DEB_DUP_NR_CTR.CD_EMP AND  
	RC_DEB.CD_FILIAL = RC_DEB_DUP_NR_CTR.CD_FILIAL AND 
	RC_DEB.NR_DP = RC_DEB_DUP_NR_CTR.NR_DP AND  
	RC_DEB.ANO = RC_DEB_DUP_NR_CTR.ANO  
	INNER JOIN RC_DEB_EST_NF_SAI ON  
	RC_DEB_DUP_NR_CTR.CD_EMP = RC_DEB_EST_NF_SAI.CD_EMP AND 
	RC_DEB_DUP_NR_CTR.CD_FILIAL = RC_DEB_EST_NF_SAI.CD_FILIAL AND  
	RC_DEB_DUP_NR_CTR.NR_DP = RC_DEB_EST_NF_SAI.NR_DP AND 
	RC_DEB_DUP_NR_CTR.ANO = RC_DEB_EST_NF_SAI.ANO  
	INNER JOIN EST_NF_SAI ON  
	RC_DEB_EST_NF_SAI.CD_EMP = EST_NF_SAI.CD_EMP AND 
	RC_DEB_EST_NF_SAI.CD_FILIAL = EST_NF_SAI.CD_FILIAL AND 
	RC_DEB_EST_NF_SAI.CD_NF = EST_NF_SAI.CD_NF  

UNION ALL
--------- 'Buscando nota de entrado no caso de devoluo de compras
Select 
	V_EST_NF_ENT_CAB.CD_EMP,
	V_EST_NF_ENT_CAB.CD_FILIAL,
	V_EST_NF_ENT_CAB.CD_NF,	
	'Nota fiscal de devoluo ref. nota fiscal entrada: ' +
	CAST(V_EST_NF_ENT_CAB.NR_NF AS VARCHAR) + ' Data entrada: ' + CONVERT (VARCHAR (10), V_EST_NF_ENT_CAB.DT_ENT,103) +
	' Movimentao: ' + cast(V_EST_NF_ENT_CAB.DS_MOV_OP as varchar) AS INFORMACAO

From EST_NF_ENT_NF_SAI INNER JOIN V_EST_NF_ENT_CAB ON  
	EST_NF_ENT_NF_SAI.CD_EMP = V_EST_NF_ENT_CAB.CD_EMP AND  
	EST_NF_ENT_NF_SAI.CD_FILIAL = V_EST_NF_ENT_CAB.CD_FILIAL AND 
	EST_NF_ENT_NF_SAI.CD_NF_ENT = V_EST_NF_ENT_CAB.CD_NF  

UNION ALL

--------- 'Buscando nota de entrado no caso de devoluo de compras
Select 
	V_EST_NF_ENT_CAB.CD_EMP,
	V_EST_NF_ENT_CAB.CD_FILIAL,
	V_EST_NF_ENT_CAB.CD_NF,
	'Nota fiscal de saida relacionada com a nota fiscal de entrada: ' + CAST(V_EST_NF_ENT_CAB.NR_NF AS VARCHAR)
	+ ' Data entrada ' + CONVERT (VARCHAR (10), V_EST_NF_ENT_CAB.DT_EMI_NF,103) + ' movimento.: ' + cast(V_EST_NF_ENT_CAB.DS_MOV_OP as varchar) AS INFORMACAO

From EST_NF_SAI_EST_NF_ENT_ADJUDICACAO INNER JOIN V_EST_NF_ENT_CAB ON  
	EST_NF_SAI_EST_NF_ENT_ADJUDICACAO.CD_EMP = V_EST_NF_ENT_CAB.CD_EMP AND  
	EST_NF_SAI_EST_NF_ENT_ADJUDICACAO.CD_FILIAL = V_EST_NF_ENT_CAB.CD_FILIAL AND 
	EST_NF_SAI_EST_NF_ENT_ADJUDICACAO.CD_NF_ENT = V_EST_NF_ENT_CAB.CD_NF  

Where  EST_NF_SAI_EST_NF_ENT_ADJUDICACAO.CD_EMP =1 AND EST_NF_SAI_EST_NF_ENT_ADJUDICACAO.CD_FILIAL =900 AND EST_NF_SAI_EST_NF_ENT_ADJUDICACAO.CD_NF =42

UNION ALL

--------'Buscando possui nota fiscal vinculo com outra nota fiscal de saida
Select 
	V_EST_NF_SAI_CAB.CD_EMP,
	V_EST_NF_SAI_CAB.CD_FILIAL,
	V_EST_NF_SAI_CAB.CD_NF,
	'Nota fiscal de saida vinculada com outra Nota fiscal de saida: ' + CAST(V_EST_NF_SAI_CAB.NF_NF AS VARCHAR) + 
	' Data emisso: ' + CONVERT (VARCHAR (10), V_EST_NF_SAI_CAB.DT_EMI_NF,103) + ' Movimentao.: ' + cast(V_EST_NF_SAI_CAB.DS_MOV_OP as varchar) AS INFORMACAO

From  EST_NF_SAI_EST_NF_SAI INNER JOIN V_EST_NF_SAI_CAB ON 
EST_NF_SAI_EST_NF_SAI.CD_EMP = V_EST_NF_SAI_CAB.CD_EMP AND 
EST_NF_SAI_EST_NF_SAI.CD_FILIAL = V_EST_NF_SAI_CAB.CD_FILIAL AND 
EST_NF_SAI_EST_NF_SAI.CD_NF_RELACIONADA = V_EST_NF_SAI_CAB.CD_NF 

UNION ALL

-------- 'Buscando gerou o contas a receber de cupom recebido por duplicata
Select 
	PDV_VD_EST_NF_SAI.CD_EMP,
	PDV_VD_EST_NF_SAI.CD_FILIAL,
	PDV_VD_EST_NF_SAI.CD_NF,
	'Gerou duplicata na filial.: ' + CAST(RC_DEB_PDV_VD.CD_FILIAL AS VARCHAR) + ' Nmero.: ' + CAST(RC_DEB_PDV_VD.NR_DP AS VARCHAR) AS INFORMACAO

From RC_DEB_PDV_VD INNER JOIN PDV_VD_EST_NF_SAI ON  
	RC_DEB_PDV_VD.CD_EMP = PDV_VD_EST_NF_SAI.CD_EMP AND  
	RC_DEB_PDV_VD.CD_FILIAL_VD = PDV_VD_EST_NF_SAI.CD_FILIAL AND 
	RC_DEB_PDV_VD.CD_VD = PDV_VD_EST_NF_SAI.CD_VD 

UNION ALL

---------- 'Lotes de envio
Select 
	EST_NF_SAI.CD_EMP,
	EST_NF_SAI.CD_FILIAL,
	EST_NF_SAI.CD_NF,
	CASE WHEN ISNULL(EST_NF_SAI_NFE_PEND.PEND_SOLUC,0) = 1 THEN
		'Lote de envio NFE.: ' + cast(EST_NFE_LOTE.CD_NFE_LOTE as varchar)
		+ ' Data/Hora lote.: '  + CONVERT (VARCHAR (10), EST_NFE_LOTE.DT_CAD,103) + ' - ' + CONVERT (VARCHAR (8), EST_NFE_LOTE.HR_CAD,108) +
		' Usurio.: ' + cast(GLB_USU.NM_USU as varchar)
	ELSE
		'Lote de envio NFE.: ' + cast(EST_NFE_LOTE.CD_NFE_LOTE as varchar)
		+ ' Data/Hora lote.: '  + CONVERT (VARCHAR (10), EST_NFE_LOTE.DT_CAD,103) + ' - ' + CONVERT (VARCHAR (8), EST_NFE_LOTE.HR_CAD,108) +
		' Usurio.: ' + cast(GLB_USU.NM_USU as varchar) + '. Aguardando soluo'

	END AS INFORMACAO

From EST_NFE_LOTE_SAI INNER JOIN EST_NF_SAI ON  
	EST_NFE_LOTE_SAI.CD_EMP = EST_NF_SAI.CD_EMP AND  
	EST_NFE_LOTE_SAI.CD_FILIAL = EST_NF_SAI.CD_FILIAL AND 
	EST_NFE_LOTE_SAI.CD_NF = EST_NF_SAI.CD_NF  
	INNER JOIN EST_NFE_LOTE ON  
	EST_NFE_LOTE_SAI.CD_NFE_LOTE = EST_NFE_LOTE.CD_NFE_LOTE 
	INNER JOIN GLB_USU ON 
	EST_NFE_LOTE.CD_USU = GLB_USU.CD_USU 
	LEFT OUTER JOIN EST_NF_SAI_NFE_PEND ON 
	EST_NFE_LOTE_SAI.CD_EMP = EST_NF_SAI_NFE_PEND.CD_EMP AND 
	EST_NFE_LOTE_SAI.CD_FILIAL = EST_NF_SAI_NFE_PEND.CD_FILIAL AND 
	EST_NFE_LOTE_SAI.CD_NF = EST_NF_SAI_NFE_PEND.CD_NF 

UNION ALL

------- 'Lotes de envio arquivamento
Select 
	EST_NF_SAI_ARQ_DANFE.CD_EMP,
	EST_NF_SAI_ARQ_DANFE.CD_FILIAL,
	EST_NF_SAI_ARQ_DANFE.CD_NF,
	CASE WHEN ISNULL(EST_NF_SAI_ARQ_DANFE.CD_NF,0) <> 0 THEN
		'Nota fiscal de sada com xml armazenado.'
	ELSE
		'Nota fiscal sem arquivo xml armazenado.'
	END AS INFORMACAO

From EST_NF_SAI_ARQ_DANFE 

UNION ALL

---------- 'Buscando protocolo da Nfe		
Select 
	EST_NF_SAI_NFE.CD_EMP,
	EST_NF_SAI_NFE.CD_FILIAL,
	EST_NF_SAI_NFE.CD_NF,		
	'Protocolo Nfe.: ' + CAST(NR_PROTOCOLO AS VARCHAR) + ' Aut.: ' + CAST(NR_AUTORIZADOR AS VARCHAR)

From EST_NF_SAI_NFE 

UNION ALL

---------- 'Buscando pedido de vendas
Select 
	EST_NF_SAI_PED_VD.CD_EMP,
	EST_NF_SAI_PED_VD.CD_FILIAL,
	EST_NF_SAI_PED_VD.CD_NF,
	CASE WHEN ISNULL(EST_PROD_TRANSF_PED_VD.CD_CTR,0) = 0 THEN
		'Pr-Fatura.: ' + CAST(EST_PED_VD.CD_PED AS VARCHAR) + ' Emitido em.: '  + CONVERT (VARCHAR (10), EST_PED_VD.DT_EMI_PED,103) + 
		' Vinc. ressuprimento.: 0000'
	ELSE
		'Pr-Fatura.: ' + CAST(EST_PED_VD.CD_PED AS VARCHAR) + ' Emitido em.: '  + CONVERT (VARCHAR (10), EST_PED_VD.DT_EMI_PED,103) + 
		' Vinc. ressuprimento.: ' + CAST(EST_PROD_TRANSF_PED_VD.CD_CTR AS VARCHAR)
	END AS INFORMACAO

From EST_PED_VD INNER JOIN EST_NF_SAI_PED_VD ON  
	EST_PED_VD.CD_PED = EST_NF_SAI_PED_VD.CD_PED AND  
	EST_PED_VD.CD_FILIAL = EST_NF_SAI_PED_VD.CD_FILIAL AND 
	EST_PED_VD.CD_EMP = EST_NF_SAI_PED_VD.CD_EMP  
	LEFT OUTER JOIN EST_PROD_TRANSF_PED_VD ON  
	EST_PED_VD.CD_PED = EST_PROD_TRANSF_PED_VD.CD_PED AND  
	EST_PED_VD.CD_FILIAL = EST_PROD_TRANSF_PED_VD.CD_FILIAL AND 
	EST_PED_VD.CD_EMP = EST_PROD_TRANSF_PED_VD.CD_EMP  

UNION ALL
---------- ' vinculo com cupom fiscal 
Select 
	PDV_VD_EST_NF_SAI.CD_EMP,
	PDV_VD_EST_NF_SAI.CD_FILIAL,
	PDV_VD_EST_NF_SAI.CD_NF,
	'Filial.: ' + CAST(PDV_VD_EST_NF_SAI.CD_FILIAL AS VARCHAR) + ' Cupom.: ' + CAST(PDV_VD.NR_ECF AS VARCHAR) + ' Caixa/Pdv.: ' + CAST(PDV_VD.CD_CX AS VARCHAR)

From PDV_VD_EST_NF_SAI INNER JOIN PDV_VD ON  
	PDV_VD_EST_NF_SAI.CD_EMP = PDV_VD.CD_EMP  AND 
	PDV_VD_EST_NF_SAI.CD_FILIAL = PDV_VD.CD_FILIAL AND 
	PDV_VD_EST_NF_SAI.CD_VD = PDV_VD.CD_VD  

UNION ALL
----------- 'Buscando carta de correcao
SELECT
	CD_EMP,
	CD_FILIAL,
	CD_NF,
	CASE WHEN NR_AUTORIZADOR <> 0  THEN
		'Nota fiscal com carta de correo nr.: ' + cast(EST_NFE_CARTA_CORRECAO.CD_CTR_CARTA_CORRECAO as varchar)
		+ ' Autorizador.: ' + cast(NR_AUTORIZADOR as varchar) + ' Protocolo: ' + cast(NR_PROTOCOLO as varchar)
		+ ' Validada em : '  + CONVERT (VARCHAR (10), DT_RECBTO,103) + ' - ' + CONVERT (VARCHAR (8), DT_RECBTO,108)
	ELSE
		' Sem validacao na SEFAZ.'

	END AS INFORMACAO

FROM EST_NFE_CARTA_CORRECAO_EST_NF_SAI INNER JOIN EST_NFE_CARTA_CORRECAO ON
	EST_NFE_CARTA_CORRECAO_EST_NF_SAI.CD_CTR_CARTA_CORRECAO = EST_NFE_CARTA_CORRECAO.CD_CTR_CARTA_CORRECAO
	LEFT OUTER JOIN EST_NFE_CARTA_CORRECAO_VALIDADA ON
	EST_NFE_CARTA_CORRECAO.CD_CTR_CARTA_CORRECAO = EST_NFE_CARTA_CORRECAO_VALIDADA.CD_CTR_CARTA_CORRECAO


UNION ALL
---------- 'Buscando codigo do credito no fornecedor no caso de devolucao para fornecedor
SELECT 
	EST_NF_SAI.CD_EMP,
	EST_NF_SAI.CD_FILIAL,
	EST_NF_SAI.CD_NF,
	CASE WHEN ISNULL(PG_CRED_FORN_EST_NF_SAI.CD_CRED_FORN,0) > 0 THEN
		'Controle de credito junto ao fornecedor.: ' + CAST(PG_CRED_FORN_EST_NF_SAI.CD_CRED_FORN AS VARCHAR) 
	ELSE
		'Controle de credito junto ao fornecedor no encontrado.'
	END	AS INFORMACAO
        
FROM EST_NF_SAI LEFT OUTER JOIN PG_CRED_FORN_EST_NF_SAI ON
	EST_NF_SAI.CD_EMP = PG_CRED_FORN_EST_NF_SAI.CD_EMP AND
	EST_NF_SAI.CD_FILIAL = PG_CRED_FORN_EST_NF_SAI.CD_FILIAL AND
	EST_NF_SAI.CD_NF = PG_CRED_FORN_EST_NF_SAI.CD_NF
    

UNION ALL

--------- Nota fiscal de sada com nota fiscal de devoluo emitida
select 
	B.CD_EMP,
	B.CD_FILIAL,
	B.CD_NF,
	'Nota fiscal de sada com nota fiscal de devoluo emitida nmero.: ' + CAST(NR_NF AS VARCHAR) +
	' Data Devoluo.: ' + CONVERT (VARCHAR (10), DT_ENT,103) AS VARCHAR

FROM EST_NF_SAI_NF_ENT a INNER JOIN EST_NF_ENT B ON
	A.CD_EMP = B.CD_EMP AND
	A.CD_FILIAL = B.CD_FILIAL AND
	A.CD_NF_ENT = B.CD_NF

GO

